%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      MacBethAnalyis.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% Description:    This file performs the analysis of the data collected during
%                 the MacBeth tests.
%-------------------------------------------------------------------------------

if ieNotDefined('SavePlots'), SavePlots = false ; end

% Settings for Macbeth color analysis
%--------------------------------------------------------------------------
pointLoc = ...
    [94     2
    94   125
     9   125
     8     2];

% If you change the size of the sensor or other spatial parameters, you may
% have to adjust these.  You can use this routine to interactively click on
% the four corners of the MCC.  See the message in the processor window
% that tells you the order to click on the corners.
%
%[mRGB, mLocs, pSize, pointLoc] = ieMacbethSelect(vci);

method = 'sRGB';        % Use the standard method
PlotOptions = 'none';   % Don't display any plots
%--------------------------------------------------------------------------

% This produces several evaluations of the errors in the plot.
%[macbethLAB, macbethXYZ, deltaE] = macbethColorError(vci,'D65',pointLoc,method,PlotOptions);
[macbethLAB, macbethXYZ, deltaE] = macbethColorError(vci,'D65',pointLoc);

if(SavePlots)
    saveas(gcf, ['./Images/MacBethDeltaE' num2str(numSensors) 'colors_sensor' num2str(sensorIndex) '.eps'],'epsc2');
    saveas(gcf, ['./Images/MacBethDeltaE' num2str(numSensors) 'colors_sensor' num2str(sensorIndex) '.png']);
end

% Calculate the Luminance error
[yNoise,mRGB] = macbethLuminanceNoise(vci,pointLoc);

if(SavePlots)
    saveas(gcf, ['./Images/MacBethLumNoise' num2str(numSensors) 'colors_sensor' num2str(sensorIndex) '.eps'],'epsc2');
    saveas(gcf, ['./Images/MacBethLumNoise' num2str(numSensors) 'colors_sensor' num2str(sensorIndex) '.png']);
end

% Create some variables used as metrics
deltaE_avg = mean(deltaE)
yNoise_avg = mean(yNoise)


% End of File
